
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   ZQUERY.C - Zodiac Query Message Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode and build Zodiac query messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\ZQUERY.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:14   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 11:00:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:06:02   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:24:24   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:26   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////
 
#include <stdio.h>
#include <graph.h>
#include <string.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"


////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac Query message from the ZMsgBuf.
//
void DecZQuery(tMSGBUF *ZMsgBuf, tZQUERY *Msg)
{  

}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac Query message in the ZMsgBuf. 
//
void BldZQuery(tMSGBUF *ZMsgBuf, tZQUERY *Msg)
{
   PutShort  (0x81FF                       , ZMsgBuf, 1);    // message preamble
   PutShort  (Msg->MsgID                   , ZMsgBuf, 2);    // message number
   PutShort  (0                            , ZMsgBuf, 3);    // message length 
   PutShort  (Msg->MsgFlags                , ZMsgBuf, 4);    // message ack/nack
 //PutShort  (CheckSum(ZMsgBuf[0], 4)      , ZMsgBuf, 5);    // header check sum 
 
 //PutShort  (CheckSum(ZMsgBuf, 0, 6 )     , ZMsgBuf, 6);   // data check sum 
}

     
